
function [R,Br] = Iteracija(E)

% Funkcija izracunava priblizno resenje jednacine f(x)=4.*exp(x)-5.*(x+1)
% metodom proste iteracije

% Pomocnu funkciju koja zadovoljava da je x=Fi(x) i koja je kontrakcija na
% intervalu (-1,0) dobicemo prebacivanjem x na levu stranu jednacine, tj.
% x=(4.*exp(x)-5)./5, pa cemo za funkciju Fi(x) uzeti desnu stranu ove
% jednacine:
Fi='(4.*exp(x)-5)./5';

% Prvi izvod f-je Fi je Fi'(x)=(4.*exp(x))./5
% Apsolutna vrednost izvoda f-je Fi(x) je abs((4.*exp(x))./5), pa s obzirom
% da je |Fi'(-1)|=0.2943, a |Fi'(0)|=0.8000 znaci i da je cela funkcija
% |Fi'(x)|<=0.8000 (<1), pa cemo za q uzeti:
q=0.8000;

% Kriterijum zazustavljanja je:
kz=(1-q).*E./q;

% Za pocetnu vrednost cemo uzeti polovinu intervala (-1,0), tj.
y(1)=-0.5000;
x=y(1);
% Druga vrednost koja se dobija kao Fi(y(1))
y(2)=eval(Fi); 
i=2;

% a zatim pravimo iterativni niz sve dok je razlika poslednja dva clana
% niza veca od kriterijuma zaustavljanja
while abs(y(i)-y(i-1))>kz
      x=y(i);
      i=i+1;
      y(i)=eval(Fi);
end

% Poslednji dobijeni clan iterativnog niza je priblizno resenje nase
% jednacine
R=y(i);

% Br je broj iteracija koji je bio potreban za dobijanje resenja
Br=i;